import User  from '../models/user.js';

export const cambiarEstadoApoderado = async (id: number): Promise<User | null> => {
    console.log("ID recibido en cambiarEstadoApoderado:", id); // Para depuración

    if (!id || isNaN(id)) {
        throw new Error("El ID proporcionado no es válido");
    }

    const apoderado = await User.findByPk(id);

    if (!apoderado) {
        throw new Error(`Apoderado con ID ${id} no encontrado`);
    }

    // Alternar estado entre "activo" e "inactivo"
    apoderado.state = apoderado.state === 'activo' ? 'inactivo' : 'activo';

    await apoderado.save();
    return apoderado;
};