import { DataTypes, Model, Optional } from "sequelize";
import sequelize from "../db/connection.js";

interface UserAttributes {
    id: number;
    nombre?: string;
    password?: string;
    password_admin?: string;
    img_banner?: string;
    img_logo?: string;
    email?: string;
    phone?: string;
    establecimiento?: string;
    resetToken?: string;
    resetTokenExpires?: Date;
    altitud?: string;
    longitud?: string;
    state?: string;
}

interface UserCreationAttributes extends Optional<UserAttributes, "id"> {}

class User extends Model<UserAttributes, UserCreationAttributes> implements UserAttributes {
    id!: number;
    nombre?: string;
    password?: string;
    password_admin?: string;
    img_banner?: string;
    img_logo?: string;
    email?: string;
    phone?: string;
    establecimiento?: string;
    resetToken?: string;
    resetTokenExpires?: Date;
    altitud?: string;
    longitud?: string;
    state?: string;
}

User.init(
    {
        id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
        nombre: { type: DataTypes.STRING, allowNull: true },
        password: { type: DataTypes.STRING, allowNull: true },
        password_admin: { type: DataTypes.STRING, allowNull: true },
        img_banner: { type: DataTypes.STRING(50), allowNull: true },
        img_logo: { type: DataTypes.STRING(50), allowNull: true },
        email: { type: DataTypes.STRING(50), allowNull: true },
        phone: { type: DataTypes.STRING(50), allowNull: true },
        establecimiento: { type: DataTypes.STRING(50), allowNull: true },
        resetToken: { type: DataTypes.STRING(50), allowNull: true },
        resetTokenExpires: { type: DataTypes.DATE, allowNull: true },
        altitud: { type: DataTypes.STRING(50), allowNull: true },
        longitud: { type: DataTypes.STRING(50), allowNull: true },
        state: { type: DataTypes.STRING(50), allowNull: true, defaultValue: "activo" }
    },
    {
        sequelize,
        modelName: "User",
        tableName: "users",
        timestamps: true
    }
);

export default User;