import { DataTypes } from "sequelize";
import sequelize from "../db/connection.js";

export const Productos = sequelize.define("producto", {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    img: {
        type: DataTypes.STRING,
        allowNull: true
    },
    nombre: {
        type: DataTypes.STRING,
        allowNull: true
    },
    descripcion: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cantidad: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    medida: {
        type: DataTypes.STRING,
        allowNull: true
    },
    precio: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    familia: {
        type: DataTypes.STRING,
        allowNull: true
    },
    tipo:{
        type: DataTypes.STRING,
        allowNull: true
    },
    tiempo:{
        type: DataTypes.STRING,
        allowNull: true
    },
    stock: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    vendido: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    oferta:{
        type: DataTypes.BOOLEAN,
        allowNull: true
    },
    inicio:{
        type: DataTypes.BOOLEAN,
        allowNull: true
    },
    estado: {
        type: DataTypes.BOOLEAN,
        allowNull: true,
        defaultValue: true
    }
}, {
    timestamps: false
});

export default Productos