import { DataTypes, Sequelize } from "sequelize";
import sequelize from "../db/connection.js";

export const Movimientos = sequelize.define("movimientos", {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    carro: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    periodo: {
        type: DataTypes.STRING,
        allowNull: true,
        defaultValue: new Date().getFullYear()
    },
     fecha: {
        type: DataTypes.DATEONLY,
        allowNull: true,
        defaultValue: DataTypes.NOW 
    },
    hora:{
        type: DataTypes.TIME,
        allowNull: true,
        defaultValue: () => new Date().toTimeString().split(' ')[0].slice(0, 5)
    },  
    hora_confirmado:{
        type: DataTypes.TIME,
        allowNull: true
    },  
    hora_listo:{
        type: DataTypes.TIME,
        allowNull: true
    },
    hora_entregado:{
        type: DataTypes.TIME,
        allowNull: true
    },
    cantidad_items: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    total: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    nombre: {
        type: DataTypes.STRING,
        allowNull: true
    },
    telefono: {
        type: DataTypes.STRING,
        allowNull: true
    },
    metodo_pago: {
        type: DataTypes.STRING,
        allowNull: true
    },
    metodo_envio: {
        type: DataTypes.STRING,
        allowNull: true
    },
    entregado_por: {
        type: DataTypes.STRING,
        allowNull: true
    },
    foto: {
        type: DataTypes.STRING,
        allowNull: true
    },
    estado: {
        type: DataTypes.STRING,
        allowNull: true,
        defaultValue: "pedido"
    },
    tiempo_determinado: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    detalle: {
        type: DataTypes.STRING,
        allowNull: true
    }
}, {
    timestamps: false
});
export default Movimientos