import { Request, Response } from "express";
import Movimientos  from "../models/movimientos.js";

export const verMovimientos = async (req: Request, res: Response) => {
  try {
      const listMovimientos = await Movimientos.findAll();
      res.json(listMovimientos);
  } catch (error) {
      res.status(500).json({ msg: "Error interno del servidor" });
  }
};

export const verMovimiento = async (req: Request, res: Response) => {
  try {
    const { carro } = req.body; 

    if (isNaN(Number(carro))) {
      res.status(400).json({ msg: "ID inválido" });
      return 
    }

    const movimiento = await Movimientos.findOne({
      where: { carro: Number(carro) }
    });

    if (!movimiento) {
       res.status(404).json({ msg: "Movimiento no encontrado" });
       return
    }

    res.json(movimiento);
  } catch (error) {
    console.error("Error al buscar el movimiento:", error);
    res.status(500).json({ msg: "Error interno del servidor" });
  }
};

export const nuevoMovimiento = async (req: Request, res: Response) => {
  const { nombre, telefono,detalle, cantidad_items, metodo_pago, metodo_envio, total } = req.body;

  try {
    // Buscar el número de carro más alto actual
    const maxCarro = await Movimientos.max('carro') as number;
    const nuevoCarro = (isNaN(maxCarro) ? 999 : maxCarro) + 1;

    // Crear el nuevo movimiento
    await Movimientos.create({ carro: nuevoCarro, nombre, telefono,detalle, cantidad_items, metodo_pago, metodo_envio, total });

    // Emitir el evento a todos los clientes conectados
    const io = req.app.get('io');
    io.emit('nuevo-movimiento', {
      carro: nuevoCarro,
      nombre,
      telefono,
      detalle,
      cantidad_items,
      metodo_pago,
      metodo_envio,
      total
    });

     res.status(200).json({
      numero_pedido: nuevoCarro,
      msg: 'Registro completado'
    });
    return

  } catch (error) {
    res.status(400).json({
      msg: 'Ocurrió un error al guardar el movimiento',
      error
    });
    return 
  }
};

export const modificarMovimientos = async (req: Request, res: Response): Promise<void> => {
      const id = req.params.id;
      const { total, nombre, telefono, metodo_pago, metodo_envio, estado, detalle, hora_confirmado, hora_listo, hora_entregado, entregado_por, foto, tiempo_determinado } = req.body;
      try {
        const movimiento = await Movimientos.findByPk(id);
    
        if (!movimiento) {
          res.status(404).json({ error: 'Movimiento no encontrado' });
          return;
        }
    
        await movimiento.update({ total, nombre, telefono, metodo_pago, metodo_envio, estado, detalle, hora_confirmado, hora_listo, hora_entregado, entregado_por, foto, tiempo_determinado  });
    
        res.json({ message: 'actualizado correctamente' });
      } catch (error) {
        res.status(500).json({ error: 'Error al actualizar el Movimiento' });
      }
};