import { DataTypes } from "sequelize";
import sequelize from "../db/connection.js";
export const Carrito = sequelize.define("carrito", {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    carro: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    nombre: {
        type: DataTypes.STRING,
        allowNull: true
    },
    precio: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    cantidad: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    total: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    estado: {
        type: DataTypes.STRING,
        allowNull: true,
        defaultValue: "pedido"
    }
}, {
    timestamps: false
});
export default Carrito;
