import Productos from "../models/productos.js";
export const verProductos = async (req, res) => {
    try {
        const listProductos = await Productos.findAll();
        res.json(listProductos);
    }
    catch (error) {
        res.status(500).json({ msg: "Error interno del servidor" });
    }
};
export const nuevosProductos = async (req, res) => {
    try {
        const productos = req.body;
        if (!Array.isArray(productos) || productos.length === 0) {
            res.status(400).json({ msg: "Debe enviar un array de productos válido." });
            return;
        }
        const productosValidos = productos.every(prod => prod.nombre && prod.precio);
        if (!productosValidos) {
            res.status(400).json({ msg: "Todos los productos deben tener nombre y precio." });
            return;
        }
        await Productos.bulkCreate(productos);
        res.status(201).json({ msg: "Productos registrados exitosamente" });
    }
    catch (error) {
        console.error("Error al registrar productos:", error);
    }
};
export const nuevoProducto = async (req, res) => {
    const { img, nombre, descripcion, cantidad, medida, precio, familia, tipo, tiempo, stock, vendido, oferta, inicio } = req.body;
    try {
        await Productos.create({
            img,
            nombre,
            descripcion,
            cantidad,
            medida,
            precio,
            familia,
            tipo,
            tiempo,
            stock,
            vendido,
            oferta,
            inicio
        });
        res.status(200).json({
            msg: `Registro completado`
        });
    }
    catch (error) {
        res.status(400).json({
            msg: " ocurrio un error",
            error
        });
    }
};
export const modificarproducto = async (req, res) => {
    const id = req.params.id;
    const { img, nombre, descripcion, cantidad, medida, precio, familia, tipo, stock, vendido, oferta, inicio, estado } = req.body;
    try {
        const integrante = await Productos.findByPk(id);
        if (!integrante) {
            res.status(404).json({ error: 'Producto no encontrado' });
            return;
        }
        await integrante.update({ img, nombre, descripcion, cantidad, medida, precio, familia, tipo, stock, vendido, oferta, inicio, estado });
        res.json({ message: 'Producto actualizado correctamente', integrante });
    }
    catch (error) {
        res.status(500).json({ error: 'Error al actualizar el Producto' });
    }
};
export const eliminarProducto = async (req, res) => {
    const { id } = req.params;
    try {
        const producto = await Productos.findByPk(id);
        if (!producto) {
            res.status(404).json({ msg: 'Producto no encontrado' });
            return;
        }
        await producto.destroy();
        res.json({ msg: 'Producto eliminado correctamente' });
    }
    catch (error) {
        res.status(500).json({ msg: 'Error al eliminar el producto' });
    }
};
