import { Carrito } from "../models/carrito.js";
import sequelize from "../db/connection.js";
export const verCarritos = async (req, res) => {
    try {
        const carrito = await Carrito.findAll();
        res.json(carrito);
    }
    catch (error) {
        console.error("Error en getMoviment:", error);
        res.status(500).json({ msg: "Error interno del servidor", error });
    }
};
export const verCarrito = async (req, res) => {
    try {
        const { carro } = req.body;
        const carrito = await Carrito.findAll({
            where: { carro: Number(carro) }
        });
        if (!carrito) {
            res.status(404).json({ msg: "Carrito no encontrado" });
            return;
        }
        res.json(carrito);
    }
    catch (error) {
        res.status(500).json({ msg: "Error interno del servidor" });
    }
};
export const newcarrito = async (req, res) => {
    const productos = req.body;
    const transaction = await sequelize.transaction();
    try {
        if (!Array.isArray(productos) || productos.length === 0) {
            throw new Error("Debe proporcionar un array de productos válido.");
        }
        const productosConGrupo = productos.map(producto => ({
            carro: producto.carro,
            nombre: producto.nombre,
            precio: producto.precio,
            cantidad: producto.cantidad,
            total: producto.total
        }));
        await Carrito.bulkCreate(productosConGrupo, { transaction });
        await transaction.commit();
        res.status(200).json({ msg: "Datos ingresados correctamente" });
    }
    catch (error) {
        await transaction.rollback();
        console.error("Error en newcarrito:", error);
        res.status(500).json({ msg: "Error interno del servidor", error });
    }
};
export const modificarCarrito = async (req, res) => {
    const id = req.params.id;
    const { estado } = req.body;
    try {
        const carrito = await Carrito.findByPk(id);
        if (!carrito) {
            res.status(404).json({ error: 'Movimiento no encontrado' });
            return;
        }
        await carrito.update({ estado });
        res.json({ message: 'actualizado correctamente' });
    }
    catch (error) {
        res.status(500).json({ error: 'Error al actualizar el Movimiento' });
    }
};
