import jwt from 'jsonwebtoken';
const validateToken = (req, res, next) => {
    let token;
    const headerToken = req.headers['authorization'];
    if (headerToken && headerToken.startsWith('Bearer ')) {
        token = headerToken.slice(7);
    }
    if (!token && req.cookies?.token) {
        token = req.cookies.token;
    }
    if (!token) {
        res.status(401).json({ msg: 'Token no proporcionado' });
        return;
    }
    try {
        const decoded = jwt.verify(token, '12345');
        req.user = decoded;
        next();
    }
    catch (error) {
        console.error("Error validando token:", error);
        res.status(401).json({ msg: 'Token inválido' });
        return;
    }
};
export default validateToken;
