import { DataTypes, Model } from "sequelize";
import sequelize from "../db/connection.js";
class User extends Model {
}
User.init({
    id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
    nombre: { type: DataTypes.STRING, allowNull: true },
    password: { type: DataTypes.STRING, allowNull: true },
    password_admin: { type: DataTypes.STRING, allowNull: true },
    img_banner: { type: DataTypes.STRING(50), allowNull: true },
    img_logo: { type: DataTypes.STRING(50), allowNull: true },
    email: { type: DataTypes.STRING(50), allowNull: true },
    phone: { type: DataTypes.STRING(50), allowNull: true },
    establecimiento: { type: DataTypes.STRING(50), allowNull: true },
    resetToken: { type: DataTypes.STRING(50), allowNull: true },
    resetTokenExpires: { type: DataTypes.DATE, allowNull: true },
    altitud: { type: DataTypes.STRING(50), allowNull: true },
    longitud: { type: DataTypes.STRING(50), allowNull: true },
    state: { type: DataTypes.STRING(50), allowNull: true, defaultValue: "activo" }
}, {
    sequelize,
    modelName: "User",
    tableName: "users",
    timestamps: true
});
export default User;
