import path from 'path';
export const documentFileImg = async (req, file, cb) => {
    // Permitimos también webp
    const allowedTypes = /jpeg|jpg|png|gif|webp/;
    const extName = allowedTypes.test(path.extname(file.originalname).toLowerCase());
    const mimeType = allowedTypes.test(file.mimetype.toLowerCase());
    if (extName && mimeType) {
        cb(null, true);
    }
    else {
        cb(new Error('❌ Solo se permiten imágenes (jpeg, jpg, png, gif, webp)'));
    }
};
