import bcrypt from 'bcrypt';
import User from "../models/user.js";
import jwt from 'jsonwebtoken';
import nodemailer from "nodemailer";
import { cambiarEstadoApoderado } from '../services/users.js';
export const viewUser = async (req, res) => {
    const listUsers = await User.findAll();
    res.json(listUsers);
};
export const getUserInfo = async (req, res) => {
    const { nombre } = req.body;
    try {
        if (!nombre) {
            res.status(400).json({ msg: "Usuario no Existe" });
            return;
        }
        const usuario = await User.findOne({
            where: { nombre },
            attributes: ["nombre", "phone", "img_banner", "img_logo", "establecimiento", "altitud", "longitud", "state"]
        });
        if (!usuario) {
            res.status(404).json({ msg: "Usuario no encontrado" });
            return;
        }
        res.json(usuario);
    }
    catch (error) {
        console.error("Error en getUserInfo:", error);
        res.status(500).json({ msg: "Error interno del servidor" });
    }
};
export const cambiarEstado = async (req, res) => {
    try {
        const id = req.body.id;
        if (isNaN(id)) {
            res.status(400).json({ error: "ID inválido" });
            return;
        }
        const usuarioActualizado = await cambiarEstadoApoderado(id);
        if (!usuarioActualizado) {
            res.status(404).json({ error: "usuario no encontrado" });
            return;
        }
        res.json(usuarioActualizado);
    }
    catch (error) {
        console.error("Error en cambiarEstado:", error);
        res.status(500).json({ error: "Error interno del servidor" });
    }
};
export const loginUser = async (req, res) => {
    const { nombre, password } = req.body;
    try {
        const user = await User.findOne({ where: { nombre } });
        if (!user) {
            res.status(400).json({ msg: 'Usuario no existe' });
            return;
        }
        const passwordValiduser = await bcrypt.compare(password, user.password);
        const passwordValidadmin = await bcrypt.compare(password, user.password_admin);
        if (!passwordValiduser && !passwordValidadmin) {
            res.status(400).json({ msg: 'Contraseña incorrecta' });
            return;
        }
        const tipoAcceso = passwordValidadmin ? 'admin' : 'user';
        const n_user = user.name_user;
        const token = jwt.sign({ user: user.name_user, tipoAcceso }, '12345', { expiresIn: "7d" });
        res.cookie("token", token, {
            httpOnly: true,
            secure: true,
            sameSite: 'none',
            maxAge: 7 * 24 * 60 * 60 * 1000,
        });
        res.status(200).json({ token, tipoAcceso, n_user });
    }
    catch (error) {
        console.error('Error en loginUser:', error);
        res.status(500).json({ msg: 'Error interno del servidor' });
    }
};
export const newUser = async (req, res) => {
    const { nombre, password, password_admin, img_banner, img_logo, phone, establecimiento, altitud, longitud } = req.body;
    const user = await User.findOne({ where: { nombre: nombre } });
    if (user) {
        res.status(400).json({
            msg: 'Este Usuario Ya esta Registrado'
        });
        return;
    }
    const hashedPassword = await bcrypt.hash(password, 10);
    const hashedPassword1 = await bcrypt.hash(password_admin, 10);
    try {
        await User.create({
            nombre,
            password: hashedPassword,
            password_admin: hashedPassword1,
            img_banner,
            img_logo,
            phone,
            establecimiento,
            altitud,
            longitud
        });
        res.status(200).json({
            msg: `Hola, ${nombre} se ha enviado un correo para Activacion `
        });
    }
    catch (error) {
        res.status(400).json({
            msg: " ocurrio un error",
            error
        });
    }
};
export const recoveryUser = async (req, res) => {
    const { nombre, email } = req.body;
    try {
        const user = await User.findOne({ where: { nombre, email } });
        if (!user) {
            res.status(400).json({ msg: "Usuario no encontrado con los datos proporcionados" });
            return;
        }
        const token = jwt.sign({ id: user.id, email: user.email }, '12345', { expiresIn: "1h" });
        await user.update({ resetToken: token, resetTokenExpires: new Date(Date.now() + 3600000) });
        const transporter = nodemailer.createTransport({
            host: 'mail.distribuyendo.cl',
            port: 465,
            secure: true,
            auth: {
                user: 'tesoreria@distribuyendo.cl',
                pass: 'TpcNXtl,!5wf',
            },
            tls: {
                rejectUnauthorized: false,
            }
        });
        const htmlContent = `
        <!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
</head>
<body style="font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px;">
  <div style="max-width: 600px; background: #fff; padding: 20px; border-radius: 10px; margin: auto; border: 1px solid #ddd;">
    <div style="text-align: center; margin-bottom: 20px;">
      <img src="https://tesoreria.distribuyendo.cl/img/tesoreria.png" alt="Tesoreria" style="max-width: 150px;">
    </div>
    <h2 style="color: #4CAF50; text-align: center;">🔑 Recuperación de Contraseña</h2>
    <p>Hola,${user.nombre}</p>
    <p>Hemos recibido una solicitud para recuperar la contraseña asociada a este correo.</p>
    <p>Si no realizaste esta solicitud, puedes ignorar este mensaje.</p>
    <p>Haz clic en el siguiente enlace para continuar:</p>
    <div style="text-align: center; margin: 20px 0;">
      <a href="https://distribuyendo.cl/recovery?token=${token}" style="background: #4CAF50; color: #fff; padding: 10px 20px; text-decoration: none; border-radius: 5px;">Recuperar Contraseña</a>
    </div>
    <p>Este enlace expirará en 1 hora.</p>
    <hr style="margin: 30px 0; border: none; border-top: 1px solid #ddd;">
    <footer style="text-align: center; font-size: 12px; color: #555;">
      <p><strong>Distribuyendo.cl App Tesoreria</strong></p>
      <p>📍 PARCELA 99 COLONIA KENNEDY HOSPITAL COMUNA DE PAINE</p>
      <p>📞 +56940798142</p>
      <div>
        <a href="https://www.facebook.com/profile.php?id=61572815763482" style="margin: 0 5px;">🌐 Facebook</a> |
        <a href="https://www.instagram.com/distribuyendocl/" style="margin: 0 5px;">📸 Instagram</a>
      </div>
    </footer>
  </div>
</body>
</html>
      `;
        const info = await transporter.sendMail({
            from: `"Tesoreria" <tesoreria@distribuyendo.cl>`,
            to: user.email,
            subject: 'Recuperacion de Contraseña',
            html: htmlContent
        });
        res.json({ msg: "Correo de recuperación enviado exitosamente" });
    }
    catch (error) {
        console.error("Error en recoveryUser:", error);
        res.status(500).json({ msg: "Error interno del servidor" });
    }
};
export const resetPassword = async (req, res) => {
    const { token, password } = req.body;
    try {
        if (!token) {
            res.status(400).json({ msg: 'Token inválido o expirado' });
            return;
        }
        // Verificar token y extraer datos
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        }
        catch (error) {
            res.status(400).json({ msg: 'Token inválido o expirado' });
            return;
        }
        const user = await User.findOne({ where: { id: decoded.id, resetToken: token } });
        // Encriptar nueva contraseña
        const hashedPassword = await bcrypt.hash(password, 10);
        await user.update({ password: hashedPassword, resetToken: null, resetTokenExpires: null });
        res.json({ msg: 'Contraseña restablecida correctamente' });
    }
    catch (error) {
        console.error('Error en resetPassword:', error);
        res.status(500).json({ msg: 'Error interno del servidor' });
    }
};
