import multer from "multer";
import { dirname, join } from "path";
import { fileURLToPath } from "url";
import path from "path";
import { documentFileImg } from "./uploadtypedocument.js";
const CURRENT_DIR = dirname(fileURLToPath(import.meta.url));
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, join(CURRENT_DIR, '../../img/productos'));
    },
    filename: (req, file, cb) => {
        const ext = path.extname(file.originalname);
        cb(null, `${Date.now()}-ukhaisushi${ext}`);
    },
});
export const upload_img_pruducto = multer({
    storage,
    limits: { fileSize: 10 * 1024 * 1024 }, // 10MB
    fileFilter: documentFileImg,
});
export const Upload_Verifi = async (req, res) => {
    if (!req.file) {
        console.error("No se subió ningún archivo");
        res.status(400).json({ message: "No se subió ningún archivo" });
        return;
    }
    console.log("Archivo recibido:", req.file);
    res.status(200).json({
        message: "Imagen subida con éxito",
        filename: req.file.filename,
        path: `/img/productos/${req.file.filename}`,
    });
};
